/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ClipboardProxy;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    static long GTKCLIPBOARD = OS.gtk_clipboard_get(0L);
    static long GTKPRIMARYCLIPBOARD;
    private static long TARGET;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = Clipboard.class.getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int n) {
        this.checkWidget();
        ClipboardProxy clipboardProxy = ClipboardProxy._getInstance(this.display);
        clipboardProxy.clear(this, n);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int n) {
        Object object;
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        long l = 0L;
        int[] nArray = transfer.getTypeIds();
        for (int i = 0; i < nArray.length; ++i) {
            if ((n & 1) != 0) {
                l = this.gtk_clipboard_wait_for_contents(GTKCLIPBOARD, nArray[i]);
                OS.gdk_threads_leave();
            }
            if (l != 0L) break;
            if ((n & 2) == 0) continue;
            l = this.gtk_clipboard_wait_for_contents(GTKPRIMARYCLIPBOARD, nArray[i]);
            OS.gdk_threads_leave();
        }
        if (l == 0L) {
            return null;
        }
        TransferData transferData = new TransferData();
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            transferData.type = OS.gtk_selection_data_get_data_type(l);
            transferData.pValue = OS.gtk_selection_data_get_data(l);
            transferData.length = OS.gtk_selection_data_get_length(l);
            transferData.format = OS.gtk_selection_data_get_format(l);
        } else {
            object = new GtkSelectionData();
            OS.memmove((GtkSelectionData)object, l, (long)GtkSelectionData.sizeof);
            transferData.type = ((GtkSelectionData)object).type;
            transferData.pValue = ((GtkSelectionData)object).data;
            transferData.length = ((GtkSelectionData)object).length;
            transferData.format = ((GtkSelectionData)object).format;
        }
        object = transfer.nativeToJava(transferData);
        OS.gtk_selection_data_free(l);
        return object;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray) {
        this.setContents(objectArray, transferArray, 1);
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray, int n) {
        this.checkWidget();
        if (objectArray == null || transferArray == null || objectArray.length != transferArray.length || objectArray.length == 0) {
            DND.error(5);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null && transferArray[i] != null && transferArray[i].validate(objectArray[i])) continue;
            DND.error(5);
        }
        ClipboardProxy clipboardProxy = ClipboardProxy._getInstance(this.display);
        if (!clipboardProxy.setData(this, objectArray, transferArray, n)) {
            DND.error(2002);
        }
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int n) {
        int n2;
        int[] nArray;
        this.checkWidget();
        TransferData[] transferDataArray = null;
        if ((n & 1) != 0) {
            nArray = this.getAvailableClipboardTypes();
            transferDataArray = new TransferData[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                transferDataArray[n2] = new TransferData();
                transferDataArray[n2].type = nArray[n2];
            }
        }
        if ((n & 2) != 0) {
            nArray = this.getAvailablePrimaryTypes();
            n2 = 0;
            if (transferDataArray != null) {
                TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + nArray.length];
                System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
                n2 = transferDataArray.length;
                transferDataArray = transferDataArray2;
            } else {
                transferDataArray = new TransferData[nArray.length];
            }
            for (int i = 0; i < nArray.length; ++i) {
                transferDataArray[n2 + i] = new TransferData();
                transferDataArray[n2 + i].type = nArray[i];
            }
        }
        return transferDataArray == null ? new TransferData[]{} : transferDataArray;
    }

    public String[] getAvailableTypeNames() {
        byte[] byArray;
        long l;
        int n;
        this.checkWidget();
        int[] nArray = this.getAvailableClipboardTypes();
        int[] nArray2 = this.getAvailablePrimaryTypes();
        String[] stringArray = new String[nArray.length + nArray2.length];
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            l = OS.gdk_atom_name(nArray[n]);
            if (l == 0L) continue;
            byArray = new byte[OS.strlen(l)];
            OS.memmove(byArray, l, (long)byArray.length);
            OS.g_free(l);
            stringArray[n2++] = "GTKCLIPBOARD " + new String(Converter.mbcsToWcs(null, byArray));
        }
        for (n = 0; n < nArray2.length; ++n) {
            l = OS.gdk_atom_name(nArray2[n]);
            if (l == 0L) continue;
            byArray = new byte[OS.strlen(l)];
            OS.memmove(byArray, l, (long)byArray.length);
            OS.g_free(l);
            stringArray[n2++] = "GTKPRIMARYCLIPBOARD " + new String(Converter.mbcsToWcs(null, byArray));
        }
        if (n2 < stringArray.length) {
            String[] stringArray2 = new String[n2];
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            stringArray = stringArray2;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getAvailablePrimaryTypes() {
        int[] nArray = new int[]{};
        long l = this.gtk_clipboard_wait_for_contents(GTKPRIMARYCLIPBOARD, TARGET);
        OS.gdk_threads_leave();
        if (l != 0L) {
            try {
                long l2;
                int n;
                int n2;
                if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
                    n2 = OS.gtk_selection_data_get_length(l);
                    n = OS.gtk_selection_data_get_format(l);
                    l2 = OS.gtk_selection_data_get_data(l);
                } else {
                    GtkSelectionData gtkSelectionData = new GtkSelectionData();
                    OS.memmove(gtkSelectionData, l, (long)GtkSelectionData.sizeof);
                    n2 = gtkSelectionData.length;
                    n = gtkSelectionData.format;
                    l2 = gtkSelectionData.data;
                }
                if (n2 != 0) {
                    nArray = new int[n2 * 8 / n];
                    OS.memmove(nArray, l2, (long)n2);
                }
                Object var10_7 = null;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                OS.gtk_selection_data_free(l);
                throw throwable;
            }
            OS.gtk_selection_data_free(l);
            {
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getAvailableClipboardTypes() {
        int[] nArray = new int[]{};
        long l = this.gtk_clipboard_wait_for_contents(GTKCLIPBOARD, TARGET);
        OS.gdk_threads_leave();
        if (l != 0L) {
            try {
                long l2;
                int n;
                int n2;
                if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
                    n2 = OS.gtk_selection_data_get_length(l);
                    n = OS.gtk_selection_data_get_format(l);
                    l2 = OS.gtk_selection_data_get_data(l);
                } else {
                    GtkSelectionData gtkSelectionData = new GtkSelectionData();
                    OS.memmove(gtkSelectionData, l, (long)GtkSelectionData.sizeof);
                    n2 = gtkSelectionData.length;
                    n = gtkSelectionData.format;
                    l2 = gtkSelectionData.data;
                }
                if (n2 != 0) {
                    nArray = new int[n2 * 8 / n];
                    OS.memmove(nArray, l2, (long)n2);
                }
                Object var10_7 = null;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                OS.gtk_selection_data_free(l);
                throw throwable;
            }
            OS.gtk_selection_data_free(l);
            {
            }
        }
        return nArray;
    }

    long gtk_clipboard_wait_for_contents(long l, long l2) {
        long l3 = System.currentTimeMillis();
        String string = "org.eclipse.swt.internal.gtk.dispatchEvent";
        Display display = this.display;
        display.setData(string, new int[]{16, 17, 18, 19});
        long l4 = OS.gtk_clipboard_wait_for_contents(l, l2);
        display.setData(string, null);
        long l5 = System.currentTimeMillis() - l3;
        if (l4 == 0L && l5 > 5000L) {
            ClipboardProxy._getInstance(display).setData(this, new String[]{" "}, new Transfer[]{TextTransfer.getInstance()}, l == GTKCLIPBOARD ? 1 : 2);
        }
        return l4;
    }

    static {
        byte[] byArray = Converter.wcsToMbcs(null, "PRIMARY", true);
        long l = OS.gdk_atom_intern(byArray, false);
        GTKPRIMARYCLIPBOARD = OS.gtk_clipboard_get(l);
        byArray = Converter.wcsToMbcs(null, "TARGETS", true);
        TARGET = OS.gdk_atom_intern(byArray, false);
    }
}

